<?php

namespace App\Http\Controllers;

use App\Models\Driver;
use App\Models\DriverPlan;
use App\Models\HotelBooking;
use App\Models\TourBooking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

use App\Models\User;
use App\Models\Client;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Http;

use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;

class DriverController extends Controller
{
    public function driverinsert()  {

       
        return view('admin.driver-register');
        
    }
    public function driver_itinerary($id)  {

      $data=TourBooking::FindorFail($id);
      $drivers=Driver::all();
      $hotels=HotelBooking::where('tourb_id',$data->id)->get();
      return view('admin.driver-itinerary',compact('data','hotels','drivers'));
      
  }
    // public function driver_add( Request $request)  {

    //      dd($request->all());
    //    $driver=  new Driver();
    //    $driver->name=$request->name;
    //    $slug = Str::slug($request->name, '-'); 
    //    $driver->slug= $slug;
    //    $driver->nic=$request->id;
    //    $driver->save();
    //     return back();
        
    // }
    protected function driver_add(Request $request)
    {
    //    dd($request->all());
        // Validation logic for Driver registration
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:'.Driver::class],
            'phone' => ['required', 'regex:/^\+94[0-9\s\-\(\)]+$/', 'min:10', 'unique:'.Driver::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);
        

        // Create a new Driver
        $client = Driver::create([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'phone' => $request->input('phone'),
            'password' => Hash::make($request->input('password')),
        ]);


       
        return redirect()->route('driver.list');
    }
    public function driverlist()  {
      $driver=  Driver::all();
       
        return view('admin.driver-list',compact('driver'));
        
    }
   
    public function driverplan($id)  {
        $driver=  Driver::where('id',$id)->first();
       $jobs= DriverPlan::where('driverid',$id)->where('status',1)->get();
        // dd($driver);
        
         
          return view('admin.driver-plan',compact('driver','jobs'));
          
      }
      public function jobview($id)  {
        $data=TourBooking::FindorFail($id);
        $drivers=  Driver::all();
        $hotels=HotelBooking::where('tourb_id',$data->id)->get();
        $job= DriverPlan::where('tourbid',$data->id)->first();
         
          return view('rider.jobview',compact('drivers','data','hotels','job'));
          
      }
      public function displayjob($uid)  {
        $id=DriverPlan::where('uniqueid',$uid)->first()->tourbid;
        $data=TourBooking::FindorFail($id);
        $drivers=  Driver::all();
        $hotels=HotelBooking::where('tourb_id',$data->id)->get();
        $job= DriverPlan::where('tourbid',$data->id)->first();
         
          return view('rider.smsdisplay',compact('drivers','data','hotels','job'));
          
      }

      public function driver_job( Request $request)  {

        //  dd($request->all());
       $job=  new DriverPlan();
       $job->driverid=$request->driver;
       $job->additionaldriver=$request->additionaldriver;
      $customUniqueId = hash('sha256', $request->driver . $request->tourbid);
      $job->uniqueid=$customUniqueId;
       $job->status=1;
       $job->tourbid=$request->tourbid;
       $job->ride=$request->ride;
       $job->save();

       $data=TourBooking::FindorFail($request->tourbid);
       $data->status=1;
       $data->save();

       $phone=Driver::where('id',$request->driver)->first()->phone;
    //    dd($phone);
    $sms = "Greetings, Chauffeur! Your next adventure awaits. Click the link below to dive into the captivating tour itinerary for your assigned journey: https://lankagetaways.com/display-job/$customUniqueId. To visit the invoice, use this link: https://lankagetaways.com/invoice/$request->tourbid";


        try {
            $response = Http::withHeaders([
                'Authorization' => 'Bearer 40|emxU6iHNPlsHU314v1TnnsNpa8kuOTHVLTb990BL',
                'Accept' => 'application/json'
            ])->post('https://app.fitsms.lk/api/v3/sms/send', [
                'recipient' => $phone,
                'sender_id' => 'LKGetaways',
                'type' => 'plain',
                'message' => $sms,
            ]);
    

       
        if ($response->successful()) {
          
            // $responseData = $response->json(); 
         
            // return $responseData;
        } else {
           
            $errorResponse = $response->json();
         
            return $errorResponse;
        }

        
    } catch (\Exception $e) {
    
        return ['error' => $e->getMessage()];
    }

        return redirect('/tour-list');
        
        
    }

    public function invoice($id)  {
        // $data=TourBooking::FindorFail($id);
   
         
          return view('emails.driver-invoice',compact('id'));
          
      }
    public function drivercancel($id)  {
       
     
       $jobs= DriverPlan::where('id',$id)->first();
       $jobs->delete();
       $data=TourBooking::findorFail($jobs->tourbid);
       $data->status='0';
       $data->save();
       return back();
          
      }
      public function driverdone($id)  {
        // dd($id);
        $jobs= DriverPlan::where('id',$id)->first();
        $jobs->status=2;
        $jobs->save();

        $data=TourBooking::findorFail($jobs->tourbid);
        $data->status='2';
        $data->save();
      

       $client= Client::findOrFail($data->clientid);
       $percentage = 0.01; // 1% as a decimal
       $newpont = $data->price * $percentage;
       $client->points = $client->points+$newpont;
       $client->save();
        
        return back();
           
       }
    // public function rider($slug)  {
    //     $driver=  Driver::where('slug',$slug)->first();
    //    $jobs= DriverPlan::where('driverid',$driver->id)->get();
    //     // dd($driver);
         
    //       return view('rider.rider-dashbord');
          
    //   }
    public function riderdashbord()  {
        $id =auth()->guard('driveruser')->user()->id;
     
      $driver=  Driver::where('id',$id)->first();
      $jobs= DriverPlan::where('driverid',$id)->where('status',1)->get();
       // dd($driver);
        
        return view('rider.rider-dashbord',compact('driver','jobs'));
        
    }
    public function ridercomplete()  {
        $id =auth()->guard('driveruser')->user()->id;
         $driver=  Driver::where('id',$id)->first();
         $jobs= DriverPlan::where('driverid',$id)->where('status',2)->get();
          // dd($driver);
           
           return view('rider.ridercomplet',compact('driver','jobs'));
           
       }

      
    public function  driverlogin()
    {
        return view('auth.driver-login');
    }

    public function login(Request $request)
{
    $credentials = $request->only('email', 'password');
    if (Auth::guard('driveruser')->attempt($credentials)) {
      
        return redirect('/driver/driver-dashbord'); 
    } else {
      
        return back()->withInput()->withErrors(['email' => 'Invalid credentials']);
    }
}

public function driverLogout()
{
    Auth::guard('driveruser')->logout();
    return redirect('/driver/driver-login'); 
}
public function smstest() {
    try {
        $response = Http::withHeaders([
            'Authorization' => 'Bearer 40|emxU6iHNPlsHU314v1TnnsNpa8kuOTHVLTb990BL',
            'Accept' => 'application/json'
        ])->post('https://app.fitsms.lk/api/v3/sms/send', [
            'recipient' => '+94757461443',
            'sender_id' => 'LKGetaways',
            'type' => 'plain',
            'message' => 'This is a test message',
        ]);
       
        if ($response->successful()) {
          
            $responseData = $response->json(); 
         
            return $responseData;
        } else {
           
            $errorResponse = $response->json();
         
            return $errorResponse;
        }
    } catch (\Exception $e) {
    
        return ['error' => $e->getMessage()];
    }
}



}